#ifndef _Job_Job_h
#define _Job_Job_h

#include <Core/Core.h>

namespace Upp {

template<class T>
int     GetWorkerId();
int     GetJobCount();
void    WaitForJobs();
void    CancelJobs();
bool    IsJobCancelled();

template<class T>
class Job : public Pte<Job<T>>, NoCopy {
public:
    bool        Start(Event<>&& fn);
    bool        operator&(Event<>&& fn)         { return Start(pick(fn)); }
    Job&        Finish();
    bool        IsFinished();
    void        Cancel();

    static T&   Data();

    void        Clear()                         { data = MakeOne<T>(); }
    void        operator=(const Nuller&)        { Clear(); }

    T&          GetResult()                     { Mutex::Lock __(lock); return *data;  }
    T&          operator~()                     { return GetResult(); }

    Thread      GetWorker()                     { return worker; }
    int         GetWorkerId()                   { return wid; }

    bool        IsError() const                 { return status == FAILED; }
    int         GetError() const                { return error.Get<int>(); }
    String      GetErrorDesc() const            { return error.Get<String>(); }

    Job()                                       { Init(); }
    Job(Event<>&& fn) : Job()                   { Start(pick(fn)); }
    virtual ~Job()                              { Exit(); }

private:
    One<T>              data;
    Thread              worker;
    ConditionVariable   cv;
    Mutex               lock;
    Event<>             work;
    int                 wid;
    volatile int        status;
    Tuple<int, String>  error;

    enum Status         { IDLE, WORKING, FINISHED, FAILED, EXIT };

    void Init();
    void Exit();
    void Work();
};

struct JobError : Exc {
    int code;
    JobError() : Exc(Null), code(-1) {}
    JobError(const String& reason) : Exc(reason) {}
    JobError(int rc, const String& reason) : Exc(reason), code(rc) {}
};

#include "Job.hpp"
}
#endif
